<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpensesTable extends Migration {

	public function up()
	{
		Schema::create('expenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('amount', 8,2);
			$table->longText('description');
			$table->string('receipt_file');
			$table->date('expense_date');
			$table->string('payee');
		});
	}

	public function down()
	{
		Schema::drop('expenses');
	}
}