<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function task()
	{
		return $this->hasMany('Task');
	}

	public function subscription()
	{
		return $this->hasMany('Subscription');
	}

}