<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentTable extends Migration {

	public function up()
	{
		Schema::create('department', function(Blueprint $table) {
			$table->increments('id');
			$table->json('name')->nullable();
			$table->text('description');
			$table->integer('parent_id')->unsigned()->nullable()->default('null');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('department');
	}
}