<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTechnicalProposalsTable extends Migration {

	public function up()
	{
		Schema::create('technical_proposals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->tinyInteger('brand');
			$table->string('project_name');
			$table->string('consultant_name');
			$table->string('responsible_engineer');
			$table->date('validate_date');
			$table->integer('revision_id')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('technical_proposals');
	}
}