<?php

namespace User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'User';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restaurant()
    {
        return $this->hasOne('User\User');
    }

    public function goesToRestaurant()
    {
        return $this->hasMany('User');
    }

}