<?php

namespace PWCSD\NemesiCMS\Admin\Hosting\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DomainSubdomain extends Eloquent {

	protected $table = 'domains_subdomains';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function databaseServer()
	{
		return $this->hasOne('Server', 'database_server_id');
	}

	public function domain()
	{
		return $this->belongsTo('Domain', 'domain_id');
	}

}