<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServersTable extends Migration {

	public function up()
	{
		Schema::create('servers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->string('ipaddress', 255)->index();
			$table->text('ssh_key');
			$table->boolean('service_web');
			$table->boolean('service_database');
			$table->boolean('service_email');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('servers');
	}
}