<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tag', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tag')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_activity', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_activity', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_category_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_parent_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_created_by_foreign');
		});
		Schema::table('tag', function(Blueprint $table) {
			$table->dropForeign('tag_created_by_foreign');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->dropForeign('post_tag_post_id_foreign');
		});
		Schema::table('post_tag', function(Blueprint $table) {
			$table->dropForeign('post_tag_tag_id_foreign');
		});
		Schema::table('post_activity', function(Blueprint $table) {
			$table->dropForeign('post_activity_users_id_foreign');
		});
		Schema::table('post_activity', function(Blueprint $table) {
			$table->dropForeign('post_activity_post_id_foreign');
		});
	}
}