<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image')->nullable();
			$table->string('name');
			$table->string('mobile')->unique();
			$table->string('address');
			$table->string('password');
			$table->string('login_type');
			$table->integer('social_id');
			$table->enum('notifiystatus', array('on', 'off'));
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}