<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromocodeTable extends Migration {

	public function up()
	{
		Schema::create('promocode', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('code');
			$table->enum('status', array('available', 'notavailable'))->nullable();
			$table->integer('num_use')->nullable();
			$table->date('date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('promocode');
	}
}