<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('invoice_number');
			$table->integer('order_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->decimal('total_amount');
			$table->string('payment_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}