<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('App\Models\User', 'id');
	}

	public function feedbacks()
	{
		return $this->hasMany('App/Models\FeedBack', 'id');
	}

}