<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Technician extends Eloquent {

	protected $table = 'technicians';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ratings()
	{
		return $this->hasMany('\TechnicianRating', 'technician_id');
	}

}