<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiculosTable extends Migration {

	public function up()
	{
		Schema::create('vehiculos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_marca');
			$table->string('modelo');
			$table->string('combustible', 100);
			$table->integer('puertas');
			$table->integer('ano');
			$table->integer('kilometros');
			$table->string('precio');
			$table->string('descripcion_es', 512)->nullable();
			$table->string('estado_es', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vehiculos');
	}
}