<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlannedWorkingTimeTable extends Migration {

	public function up()
	{
		Schema::create('planned_working_time', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('pernr')->nullable();
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('ws_id');
			$table->decimal('daily_working_hours');
			$table->decimal('weekly_working_hours');
			$table->decimal('monthly_working_hours');
			$table->decimal('annual_working_hours');
			$table->decimal('weekly_workdays');
			$table->integer('created_by')->nullable();
			$table->integer('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('planned_working_time');
	}
}