<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderProductTable extends Migration {

	public function up()
	{
		Schema::create('order_product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('quantity')->default('1');
			$table->decimal('price');
			$table->integer('discount')->nullable();
			$table->decimal('final_price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_product');
	}
}