<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSimulationsTable extends Migration {

	public function up()
	{
		Schema::create('simulations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('description')->nullable();
			$table->integer('lintel');
			$table->integer('height');
			$table->integer('width');
			$table->integer('space_left');
			$table->integer('space_right');
			$table->decimal('total_area', 8,2);
			$table->decimal('subtotal');
			$table->string('client_name');
			$table->text('client_address');
			$table->string('client_phone');
			$table->string('client_email');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('simulations');
	}
}