<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('role_id', 'name');

    public function lessons()
    {
        return $this->belongsToMany('Lesson', 'lesson_id');
    }

    public function quizes()
    {
        return $this->belongsToMany('Quiz', 'quiz_id');
    }

    public function question_quiz()
    {
        return $this->belongsToMany('QuestionQuiz');
    }

}