<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('role_id', 'name');

	public function lessons()
	{
		return $this->belongsToMany('Lesson', 'lesson_id');
	}

	public function quizes()
	{
		return $this->belongsToMany('Quiz', 'quiz_id');
	}

	public function question_quiz()
	{
		return $this->belongsToMany('QuestionQuiz');
	}

}