<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeviceTokensTable extends Migration {

	public function up()
	{
		Schema::create('device_tokens', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->string('token')->nullable();
			$table->enum('status', array('1', '0'))->nullable();
			$table->enum('language', array('ar', 'en'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('device_tokens');
	}
}