<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Link extends Model 
{

    protected $table = 'links';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categories()
    {
        return $this->hasOne('Category', 'id_category');
    }

    public function status()
    {
        return $this->hasOne('Status', 'id_status');
    }

}