<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function roles()
	{
		return $this->belongsToMany('App\Role');
	}

	public function loginAttempts()
	{
		return $this->hasMany('App\LoginAttempt');
	}

	public function profile()
	{
		return $this->hasOne('App\Profiel');
	}

	public function searches()
	{
		return $this->hasMany('App\Search');
	}

}