<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->integer('category_id')->unsigned();
			$table->text('categories')->nullable();
			$table->integer('brand')->unsigned();
			$table->string('feature_image', 100)->nullable();
			$table->tinyInteger('feature')->default('0');
			$table->enum('status', array('pending', 'available', 'disable'));
			$table->string('video', 100)->nullable();
			$table->double('default_price');
			$table->double('offer_price');
			$table->integer('stock');
			$table->text('notes');
			$table->integer('store_id');
			$table->integer('product_child')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}