<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('product_child')->references('id')->on('products')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_galary', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->foreign('first_attribute')->references('id')->on('attribuites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->foreign('second_attribute')->references('id')->on('attribuites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attribute_values', function(Blueprint $table) {
			$table->foreign('attribiute_id')->references('id')->on('attribuites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attribuites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->foreign('attribute_value_id')->references('id')->on('attribute_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_product_child_foreign');
		});
		Schema::table('product_galary', function(Blueprint $table) {
			$table->dropForeign('product_galary_product_id_foreign');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->dropForeign('product_attribute_compinations_product_id_foreign');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->dropForeign('product_attribute_compinations_first_attribute_foreign');
		});
		Schema::table('product_attribute_compinations', function(Blueprint $table) {
			$table->dropForeign('product_attribute_compinations_second_attribute_foreign');
		});
		Schema::table('attribute_values', function(Blueprint $table) {
			$table->dropForeign('attribute_values_attribiute_id_foreign');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->dropForeign('product_attribute_value_product_id_foreign');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->dropForeign('product_attribute_value_attribute_id_foreign');
		});
		Schema::table('product_attribute_value', function(Blueprint $table) {
			$table->dropForeign('product_attribute_value_attribute_value_id_foreign');
		});
	}
}