<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('email', 191);
			$table->date('birthdate');
			$table->string('password', 191);
			$table->string('image', 191);
			$table->string('address', 191);
			$table->string('job_title', 191);
			$table->enum('user_type', array('user', 'vendor', 'admin'));
			$table->enum('status', array('online', 'ofline'));
			$table->enum('gender', array('male', 'female'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}