<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsDataTable extends Migration {

	public function up()
	{
		Schema::create('settings_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('setting_id')->unsigned();
			$table->string('name', 191);
			$table->text('description');
			$table->text('working_hours');
			$table->string('keywords', 191);
			$table->integer('lang_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('settings_data');
	}
}