<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultationsTable extends Migration {

	public function up()
	{
		Schema::create('consultations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->datetime('consultation_date');
			$table->enum('status', array(''));
			$table->text('notes');
		});
	}

	public function down()
	{
		Schema::drop('consultations');
	}
}