<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('category_id')->unsigned();
			$table->string('name');
			$table->float('price');
			$table->mediumText('description');
			$table->string('image');
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->float('duration');
			$table->string('whatsapp_link');
			$table->string('telegram_link');
			$table->string('telegram_channel_link');
			$table->boolean('is_active');
			$table->boolean('show_teachers_names');
			$table->float('certificate_price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}