<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesInquiriesTable extends Migration {

	public function up()
	{
		Schema::create('courses_inquiries', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('TECHNICAL', 'EDUCATIONAL'));
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->string('content');
			$table->boolean('is_public');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses_inquiries');
	}
}