<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->integer('group_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->integer('content_id')->unsigned();
			$table->tinyInteger('allow_comments');
			$table->tinyInteger('moderate_comments');
			$table->tinyInteger('pinned');
			$table->timestamp('published_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}