<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'salesman_id', 'client_id', 'event_id', 'attendees_number', 'attendees_type', 'date', 'from', 'to', 'address_id', 'subtotal', 'vat', 'total', 'paid', 'due', 'status', 'refund_amount', 'down_payment');

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function event()
	{
		return $this->belongsTo('Event', 'event_id');
	}

	public function products()
	{
		return $this->belongsToMany('Product', 'order_product', 'order_id', 'product_id');
	}

	public function salesman()
	{
		return $this->belongsTo('Salesman', 'salesman_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function address()
	{
		return $this->belongsTo('Address', 'address_id');
	}

}