<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'description_en', 'description_ar', 'price', 'unit', 'category_id');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}