<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActionsTable extends Migration {

	public function up()
	{
		Schema::create('actions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('project_id')->nullable();
			$table->integer('milestone_id')->nullable();
			$table->integer('job_id')->nullable();
			$table->integer('by')->nullable();
			$table->float('timespent', 16,2)->nullable();
			$table->longText('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('actions');
	}
}