<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStationsTable extends Migration {

	public function up()
	{
		Schema::create('stations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('area_name');
			$table->integer('state_district_local_body_id')->unsigned();
			$table->double('latitude');
			$table->double('logintude');
			$table->integer('contact_person_id')->unsigned();
			$table->string('station_id', 255);
			$table->string('station_band', 100);
		});
	}

	public function down()
	{
		Schema::drop('stations');
	}
}