<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHonorairesTable extends Migration {

	public function up()
	{
		Schema::create('honoraires', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contrat_id')->unsigned();
			$table->float('base_honoraire');
			$table->decimal('prime', 4,2);
			$table->float('honoraire');
			$table->datetime('date');
			$table->integer('nombre_eleves')->unsigned()->nullable();
			$table->float('CA_matiere');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('honoraires');
	}
}