<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatieresTable extends Migration {

	public function up()
	{
		Schema::create('matieres', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('professeur_id')->unsigned()->nullable()->index();
			$table->string('nom', 191);
			$table->tinyInteger('effectif');
			$table->enum('type', array('enfant', 'adulte', 'stage'));
			$table->string('descriptif', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('matieres');
	}
}