<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAisAirportTable extends Migration {

	public function up()
	{
		Schema::create('ais_airport', function(Blueprint $table) {
			$table->increments('airport_id');
			$table->string('icao', 4);
			$table->string('iata', 3)->nullable();
			$table->string('name', 125);
			$table->integer('region_id')->unsigned();
			$table->smallInteger('type')->unsigned();
			$table->smallInteger('elevation')->unsigned();
			$table->decimal('longitude', 12,8);
			$table->decimal('latitude', 12,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ais_airport');
	}
}