<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHostVulnerabilityTable extends Migration {

	public function up()
	{
		Schema::create('HostVulnerability', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 64);
			$table->string('description', 168);
			$table->string('tags', 168);
			$table->string('url', 128);
			$table->text('request');
			$table->text('response');
			$table->timestampsTz('dateClosed');
			$table->timestampsTz('dateVerified');
			$table->timestampsTz('dateRejected');
			$table->timestampsTz('dateMarkedFalsePositive');
			$table->integer('closedBy');
			$table->integer('verifiedBy');
			$table->integer('rejectedBy');
		});
	}

	public function down()
	{
		Schema::drop('HostVulnerability');
	}
}