<?php

namespace App\Hosts;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Hosts extends Eloquent {

	protected $table = 'Host';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Hosts()
	{
		return $this->hasMany('HostVulnerability');
	}

	public function hostsHasScan()
	{
		return $this->hasOne('Scans');
	}

}