<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('address', 255);
			$table->string('post_code', 255);
			$table->integer('sru_number')->unique()->unsigned();
			$table->string('tel_no', 255);
			$table->string('mob_no', 255);
			$table->string('kin', 255);
			$table->text('issues')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}