<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('EngineId')->references('id')->on('Engines')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('UpholsteryId')->references('id')->on('Upholstery')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('RetailerId')->references('id')->on('Retailer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('MediaId')->references('id')->on('Medias')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('ConsumptionUrbanId')->references('id')->on('ConsumptionUrban')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('ConsumptionExtraUrbanId')->references('id')->on('ConsumptionExtraUrban')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('ConsumptionCombinedId')->references('id')->on('ConsumptionCombined')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->foreign('EnergyEfficiencyClassId')->references('id')->on('EnergyEfficiency')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('VehicleEquipment', function(Blueprint $table) {
			$table->foreign('VehicleId')->references('id')->on('Vehicles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('VehicleEquipment', function(Blueprint $table) {
			$table->foreign('EquipmentId')->references('id')->on('Equipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('VehicleVehicleData', function(Blueprint $table) {
			$table->foreign('VehicleId')->references('id')->on('Vehicles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('VehicleVehicleData', function(Blueprint $table) {
			$table->foreign('VehicleDataId')->references('id')->on('VehicleData')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ThreeSixtyDegreeImageUrls', function(Blueprint $table) {
			$table->foreign('MediaId')->references('id')->on('Medias')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('VehicleImageUrls', function(Blueprint $table) {
			$table->foreign('MediaId')->references('id')->on('Medias')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ThreeSixtyDegreeMobileImageUrls', function(Blueprint $table) {
			$table->foreign('MediaId')->references('id')->on('Medias')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('CustomerRequests', function(Blueprint $table) {
			$table->foreign('VehicleId')->references('id')->on('Vehicles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('CustomerRequests', function(Blueprint $table) {
			$table->foreign('RetailerId')->references('id')->on('Retailer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('RetailerId')->references('id')->on('Retailer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_EngineId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_UpholsteryId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_RetailerId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_MediaId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_ConsumptionUrbanId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_ConsumptionExtraUrbanId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_ConsumptionCombinedId_foreign');
		});
		Schema::table('Vehicles', function(Blueprint $table) {
			$table->dropForeign('Vehicles_EnergyEfficiencyClassId_foreign');
		});
		Schema::table('VehicleEquipment', function(Blueprint $table) {
			$table->dropForeign('VehicleEquipment_VehicleId_foreign');
		});
		Schema::table('VehicleEquipment', function(Blueprint $table) {
			$table->dropForeign('VehicleEquipment_EquipmentId_foreign');
		});
		Schema::table('VehicleVehicleData', function(Blueprint $table) {
			$table->dropForeign('VehicleVehicleData_VehicleId_foreign');
		});
		Schema::table('VehicleVehicleData', function(Blueprint $table) {
			$table->dropForeign('VehicleVehicleData_VehicleDataId_foreign');
		});
		Schema::table('ThreeSixtyDegreeImageUrls', function(Blueprint $table) {
			$table->dropForeign('ThreeSixtyDegreeImageUrls_MediaId_foreign');
		});
		Schema::table('VehicleImageUrls', function(Blueprint $table) {
			$table->dropForeign('VehicleImageUrls_MediaId_foreign');
		});
		Schema::table('ThreeSixtyDegreeMobileImageUrls', function(Blueprint $table) {
			$table->dropForeign('ThreeSixtyDegreeMobileImageUrls_MediaId_foreign');
		});
		Schema::table('CustomerRequests', function(Blueprint $table) {
			$table->dropForeign('CustomerRequests_VehicleId_foreign');
		});
		Schema::table('CustomerRequests', function(Blueprint $table) {
			$table->dropForeign('CustomerRequests_RetailerId_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_RetailerId_foreign');
		});
	}
}