<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clients extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Governments()
    {
        return $this->belongsTo('Governments', 'government_id');
    }

    public function Donitions()
    {
        return $this->hasMany('Donation');
    }

    public function Client_Notification()
    {
        return $this->hasMany('Client_notification');
    }

    public function Contact()
    {
        return $this->hasMany('Contact');
    }

    public function Blood_Type()
    {
        return $this->hasOne('Blood_type', 'blood_id');
    }

    public function Fav_Aticles()
    {
        return $this->hasMany('Fav_Article');
    }

}