<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCheckingsTable extends Migration {

	public function up()
	{
		Schema::create('checkings', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('qrcode_id')->unsigned();
			$table->datetime('checking_date');
			$table->datetime('checkout_date');
			$table->enum('location', array('INTERNAL', 'EXTERNAL'));
			$table->integer('entity_id')->unsigned();
			$table->text('comments')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('checkings');
	}
}