<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntitiesTable extends Migration {

	public function up()
	{
		Schema::create('entities', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('acronym', 15)->nullable();
			$table->integer('parent_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('entities');
	}
}