<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantsTable extends Migration {

	public function up()
	{
		Schema::create('tenants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('domain');
			$table->integer('user_id')->unsigned();
			$table->string('db_name');
			$table->string('db_user');
			$table->string('db_pass');
			$table->string('redis_user');
			$table->string('redis_pass');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tenants');
	}
}