<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('call_logs', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('campaign_contact', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_contact', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('campaign_report', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Users')
						->onDelete('no action')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('skus', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sku_order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sku_order_items', function(Blueprint $table) {
			$table->foreign('sku_id')->references('id')->on('skus')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_flow_two', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items_flow_two', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order_flow_two')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sku_flow_two', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_tenant_id_foreign');
		});
		Schema::table('tenants', function(Blueprint $table) {
			$table->dropForeign('tenants_user_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_user_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_role_id_foreign');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_user_id_foreign');
		});
		Schema::table('call_logs', function(Blueprint $table) {
			$table->dropForeign('call_logs_agent_id_foreign');
		});
		Schema::table('campaign_contact', function(Blueprint $table) {
			$table->dropForeign('campaign_contact_campaign_id_foreign');
		});
		Schema::table('campaign_contact', function(Blueprint $table) {
			$table->dropForeign('campaign_contact_contact_id_foreign');
		});
		Schema::table('campaign_report', function(Blueprint $table) {
			$table->dropForeign('campaign_report_campaign_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_agent_id_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_contact_id_foreign');
		});
		Schema::table('skus', function(Blueprint $table) {
			$table->dropForeign('skus_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_contact_id_foreign');
		});
		Schema::table('sku_order_items', function(Blueprint $table) {
			$table->dropForeign('sku_order_items_order_id_foreign');
		});
		Schema::table('sku_order_items', function(Blueprint $table) {
			$table->dropForeign('sku_order_items_sku_id_foreign');
		});
		Schema::table('order_flow_two', function(Blueprint $table) {
			$table->dropForeign('order_flow_two_contact_id_foreign');
		});
		Schema::table('order_items_flow_two', function(Blueprint $table) {
			$table->dropForeign('order_items_flow_two_order_id_foreign');
		});
		Schema::table('sku_flow_two', function(Blueprint $table) {
			$table->dropForeign('sku_flow_two_product_id_foreign');
		});
	}
}