<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Employes', function(Blueprint $table) {
			$table->foreign('Service_id')->references('id')->on('Services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employes', function(Blueprint $table) {
			$table->foreign('Situation_conjoint_id')->references('id')->on('Situations_conjoint')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Employes', function(Blueprint $table) {
			$table->foreign('Etat_conjugal_id')->references('id')->on('Etat_conjugal')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->foreign('Employe_id')->references('id')->on('Employes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->foreign('SFT_employe_id_engagement')->references('id')->on('Engagement_SFT')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Enfants', function(Blueprint $table) {
			$table->foreign('Sexe_id')->references('id')->on('Sexe')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Enfants', function(Blueprint $table) {
			$table->foreign('Situation_enfant_id')->references('id')->on('Situations_enfant')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Situations_enfant', function(Blueprint $table) {
			$table->foreign('Affichage_situation_enfant_id')->references('id')->on('Affichage_situation_enfant')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Avoir_enfant', function(Blueprint $table) {
			$table->foreign('Employe_id')->references('id')->on('Employes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Avoir_enfant', function(Blueprint $table) {
			$table->foreign('Enfant_id')->references('id')->on('Enfants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Employes', function(Blueprint $table) {
			$table->dropForeign('Employes_Service_id_foreign');
		});
		Schema::table('Employes', function(Blueprint $table) {
			$table->dropForeign('Employes_Situation_conjoint_id_foreign');
		});
		Schema::table('Employes', function(Blueprint $table) {
			$table->dropForeign('Employes_Etat_conjugal_id_foreign');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->dropForeign('Demande_Employe_id_foreign');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->dropForeign('Demande_SFT_employe_id_engagement_foreign');
		});
		Schema::table('Enfants', function(Blueprint $table) {
			$table->dropForeign('Enfants_Sexe_id_foreign');
		});
		Schema::table('Enfants', function(Blueprint $table) {
			$table->dropForeign('Enfants_Situation_enfant_id_foreign');
		});
		Schema::table('Situations_enfant', function(Blueprint $table) {
			$table->dropForeign('Situations_enfant_Affichage_situation_enfant_id_foreign');
		});
		Schema::table('Avoir_enfant', function(Blueprint $table) {
			$table->dropForeign('Avoir_enfant_Employe_id_foreign');
		});
		Schema::table('Avoir_enfant', function(Blueprint $table) {
			$table->dropForeign('Avoir_enfant_Enfant_id_foreign');
		});
	}
}