<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContribuyenteTable extends Migration {

	public function up()
	{
		Schema::create('contribuyente', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('documento_tipo_id')->unsigned();
			$table->integer('documento_nro')->unsigned();
			$table->string('apellido', 100);
			$table->string('nombre', 100);
			$table->string('email', 100);
			$table->boolean('email_validado')->nullable();
			$table->string('telefono', 100)->nullable();
			$table->string('telefono2', 100)->nullable();
			$table->integer('codigo')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contribuyente');
	}
}