<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticulosTable extends Migration {

	public function up()
	{
		Schema::create('articulos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('codigo_ean', 25)->unique()->nullable();
			$table->integer('familia_id')->unsigned();
			$table->text('descripcion_interna')->nullable();
			$table->text('descripcion_cliente')->nullable();
			$table->integer('tipo_iva_id')->unsigned();
			$table->integer('fabricante_id')->unsigned();
			$table->text('observaciones');
			$table->integer('stock_minimo')->unsigned()->default('0');
			$table->integer('stock_maximo')->unsigned()->default('9999999');
			$table->float('maximo_descuento_aplicable')->default('100');
			$table->integer('almacen_preferido_id')->unsigned()->nullable();
			$table->float('alto')->default('0');
			$table->float('ancho')->default('0');
			$table->integer('proveedor_preferido_id')->unsigned()->nullable();
			$table->float('profundidad')->default('0');
			$table->float('descuento_preferido')->default('0');
			$table->float('peso')->nullable()->default('0');
			$table->string('nombre');
			$table->text('imagenes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('articulos');
	}
}