<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFacturasTable extends Migration {

	public function up()
	{
		Schema::create('facturas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('serie')->unsigned();
			$table->integer('numero')->unsigned();
			$table->date('fecha');
			$table->enum('estado', array('pendiente', 'cobrada', 'devuelta', 'anulada'));
			$table->text('observaciones')->nullable();
			$table->float('porcentaje_cobro')->default('0');
			$table->integer('cliente_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('facturas');
	}
}